/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.platform;

import architectury_inject_architectury_common_87458fa40cde4108b107c7a9f100c12c_1f8e6ed4036010a0c1a34d3afaf5c8c52e7ebc9157205627825ab315c449d6ccarchitectury4984devjar.PlatformMethods;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Mod;
import dev.architectury.platform.forge.PlatformImpl;
import dev.architectury.utils.Env;
import java.nio.file.Path;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;

public final class Platform {
    private static int simpleLoaderCache = -1;

    private Platform() {
    }

    public static boolean isFabric() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 0;
    }

    public static boolean isForge() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 1;
    }

    private static void updateLoaderCache() {
        if (simpleLoaderCache != -1) {
            return;
        }
        switch (PlatformMethods.getCurrentTarget()) {
            case "fabric": {
                simpleLoaderCache = 0;
                break;
            }
            case "forge": {
                simpleLoaderCache = 1;
            }
        }
    }

    public static String getMinecraftVersion() {
        return SharedConstants.m_183709_().getId();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameFolder() {
        return PlatformImpl.getGameFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigFolder() {
        return PlatformImpl.getConfigFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getModsFolder() {
        return PlatformImpl.getModsFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Env getEnvironment() {
        return PlatformImpl.getEnvironment();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Dist getEnv() {
        return PlatformImpl.getEnv();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String id) {
        return PlatformImpl.isModLoaded(id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Mod getMod(String id) {
        return PlatformImpl.getMod(id);
    }

    public static Optional<Mod> getOptionalMod(String id) {
        try {
            return Optional.of(Platform.getMod(id));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<Mod> getMods() {
        return PlatformImpl.getMods();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<String> getModIds() {
        return PlatformImpl.getModIds();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopmentEnvironment() {
        return PlatformImpl.isDevelopmentEnvironment();
    }
}

